var backendIncludes = '../customAssets/backend/backendIncludes.php';
var sId = localStorage.getItem('loggedInId');

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

$(() => {

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'activeexams', //String //Mandatory
            conditions: "WHERE sId = '" + sId + "'", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                $(".studentActiveExams").html(result.data.length);
            }
        });


    $.post(backendIncludes,
        {
            requestType: 'selectLeftJoinQuery',
            tableA: 'exams', //String //Mandatory
            tableB: 'activeexams', //String //Mandatory
            tableAColumns: ['id', 'name'], //Array //Mandatory
            columns: 'A.id,A.name', //String //Mandatory
            onConditions: "ON B.sId = '" + sId + "' AND A.id = B.eId", //String //Mandatory
            conditions: "WHERE B.eId IS NULL", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                $(".studentUnAttendedExams").html(result.data.length);
            }
        });


    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'results', //String //Mandatory
            conditions: "WHERE sId = '" + sId + "'", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                $(".studentClearedExams").html(result.data.length);
            }
        });



    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'activeexams', //String //Mandatory
            conditions: "WHERE sId = '" + sId + "' AND status = 'Active'", //String //Non Mandatory
            limit: 1
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {

                $.post(backendIncludes,
                    {
                        requestType: 'selectQuery',
                        table: 'exams', //String //Mandatory
                        conditions: "WHERE id = '" + result.data[0].eId + "'", //String //Non Mandatory
                    }, (resultExams) => {
                        resultExams = JSON.parse(resultExams);
                        if (resultExams.status) {

                            $.post(backendIncludes,
                                {
                                    requestType: 'selectQuery',
                                    table: 'examquestions', //String //Mandatory
                                    conditions: "WHERE eId = '" + result.data[0].eId + "'", //String //Non Mandatory
                                }, (resultExamQuestions) => {
                                    resultExamQuestions = JSON.parse(resultExamQuestions);
                                    if (resultExamQuestions.status) {

                                        $.post(backendIncludes,
                                            {
                                                requestType: 'selectQuery',
                                                table: 'examsubjects', //String //Mandatory
                                                conditions: "WHERE eId = '" + result.data[0].eId + "'", //String //Non Mandatory
                                            }, (resultExamSubjects) => {
                                                resultExamSubjects = JSON.parse(resultExamSubjects);
                                                if (resultExamSubjects.status) {

                                                    var totalTimeH = 0;
                                                    var totalTimeM = 0;
                                                    resultExamSubjects.data.forEach((timeIndi) => {
                                                        timeIndiArray = timeIndi.time.split(":");
                                                        totalTimeH = parseInt(totalTimeH) + parseInt(timeIndiArray[0]);
                                                        totalTimeM = parseInt(totalTimeM) + parseInt(timeIndiArray[1]);
                                                        if (totalTimeH.toString().length == 1) {
                                                            totalTimeH = '0' + totalTimeH;
                                                        }
                                                        if (totalTimeM.toString().length == 1) {
                                                            totalTimeM = '0' + totalTimeM;
                                                        }
                                                    });
                                                    var totalTime = (totalTimeH + ':' + totalTimeM);

                                                    $.post(backendIncludes,

                                                        {
                                                            requestType: 'selectQuery',
                                                            table: 'examresults', //String //Mandatory
                                                            conditions: "WHERE aEId = '" + result.data[0].id + "'", //String //Non Mandatory
                                                        }, (activeExamAnswers) => {
                                                            activeExamAnswers = JSON.parse(activeExamAnswers);
                                                            if (activeExamAnswers.status) {
                                                                var progress = (activeExamAnswers.data.length == 0) ? 0 : (Math.round((activeExamAnswers.data.length / resultExamQuestions.data.length) * 100))
                                                                var progressDeg = progress * 3.6;
                                                                $(".runningExam").html(`<div class="row">
                                                                                <div class="col-lg-3 col-md-3 dash-widget1">
                                                                                    <div class="progressCircle" data-progress="${progress}" style="--progress: ${progressDeg}deg;">
                                                                                        ${progress}%
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-lg-3 col-md-3">
                                                                                    <div class="dash-details">
                                                                                        <div class="lesson-activity">
                                                                                            <div class="lesson-imgs">
                                                                                                <img src="../../panelAssets/img/icons/lesson-icon-01.svg" alt="">
                                                                                            </div>
                                                                                            <div class="views-lesson">
                                                                                                <h5>Test Name</h5>
                                                                                                <h4>${resultExams.data[0].name}</h4>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="lesson-activity">
                                                                                            <div class="lesson-imgs">
                                                                                                <img src="../../panelAssets/img/icons/lesson-icon-02.svg" alt="">
                                                                                            </div>
                                                                                            <div class="views-lesson">
                                                                                                <h5>Subjects</h5>
                                                                                                <h4>${resultExamSubjects.data.length} subjects</h4>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="lesson-activity">
                                                                                            <div class="lesson-imgs">
                                                                                                <img src="../../panelAssets/img/icons/lesson-icon-03.svg" alt="">
                                                                                            </div>
                                                                                            <div class="views-lesson">
                                                                                                <h5>Time</h5>
                                                                                                <h4>${totalTime} H:m</h4>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-lg-3 col-md-3">
                                                                                    <div class="dash-details">
                                                                                        <div class="lesson-activity">
                                                                                            <div class="lesson-imgs">
                                                                                                <img src="../../panelAssets/img/icons/lesson-icon-04.svg" alt="">
                                                                                            </div>
                                                                                            <div class="views-lesson">
                                                                                                <h5>Questions</h5>
                                                                                                <h4>${resultExamQuestions.data.length} Q&A</h4>
                                                                                            </div>
                                                                                        </div>
                                                                                        <div class="lesson-activity">
                                                                                            <div class="lesson-imgs">
                                                                                                <img src="../../panelAssets/img/icons/lesson-icon-06.svg" alt="">
                                                                                            </div>
                                                                                            <div class="views-lesson">
                                                                                                <h5>Questions Type</h5>
                                                                                                <h4>MCQ</h4>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-lg-3 col-md-3 d-flex align-items-center justify-content-center">
                                                                                    <div class="skip-group">
                                                                                        <button type="button" activeExam-id="${result.data[0].id}" 
                                                                                                class="btn btn-info skip-btn abandonExam">Abandon</button>
                                                                                        <a activeExam-id="${result.data[0].id}"
                                                                                            class="btn btn-info continue-btn examPanel">
                                                                                            <span class="spinner-border spinner-border-sm me-2"
                                                                                                role="status"></span>
                                                                                            In Progress
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                            </div>`);

                                                            }
                                                        });

                                                }
                                            });

                                    }
                                });

                        }
                    });

            }
        });

});


$(document).on("click", ".examPanel", function () {
    localStorage.activeExamId = $(this).attr("activeExam-id");
    window.location.replace("../../exam/instructions/");
});

$(document).on("click", ".abandonExam", function () {
    activeExamId = $(this).attr("activeExam-id");
    $.post(backendIncludes,
        {
            requestType: 'updateQuery',
            table: 'activeexams',  //String //Mandatory
            parameters: {  //Object //Mandatory
                status: 'Abandoned',
            },
            conditions: {  //Object //Mandatory
                id: activeExamId
            }
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                $(".runningExam").html(`<div class="row noActiveExams">Currently there are no active exams</div>`)
                notificationTrigger('Test Abandoned', warningColor);
            }
        });
});