<?php 
    include('db.php');
    include('genericFunctions.php');

    $requestType =  $_POST['requestType'];
    $result = (object)[];
    $successColor = '#76a93a';
    $warningColor = '#c3973d';
    $failureColor = '#c02020';

    if($requestType == 'login') {
        $email = $_POST["email"];
        $password = md5($_POST["password"]);
        if(emailCheck($conn,$email)) {
           if(credentialsCheck($conn,$email,$password)) {
            $_SESSION['email'] = $email;
            $result->status = true;
            $result->notification = 'You have logged in successfully';
            $result->notificationbg = $successColor;
           } else {
            $result->status = false;
            $result->notification = 'Your credentials seem to be incorrect';
            $result->notificationbg = $warningColor;
           }
        } else {
            $result->status = false;
            $result->notification = 'There is no account exists with this Email';
            $result->notificationbg = $failureColor;
        }
        echo json_encode($result);
    }

    if($requestType == 'forgotPassword') {
        $email = $_POST["email"];
        if(emailCheck($conn,$email)) {
            if(passwordReset($conn,$email)) {
                $result->status = true;
                $result->notification = 'Password reset link sent successfully';
                $result->notificationbg = $successColor;
            }
        } else {
            $result->status = false;
            $result->notification = 'There is no account exists with this Email';
            $result->notificationbg = $failureColor;
        }
        echo json_encode($result);
    }

    if($requestType == 'isSession') {
        $sessionEmail = sessionCheck($conn);
        if($sessionEmail == false) {
            $result->status = false;
        } else {
            $result->status = true;
            $result->sessionEail = $sessionEmail;
        }
        echo json_encode($result);
    }
    
    if($requestType == 'selectQuery') {

        $table = $_POST["table"];
        if(isset($_POST["conditions"])) {
            $conditions = $_POST["conditions"];
        } else {
            $conditions = 'WHERE 1 = 1';
        }
        if(isset($_POST["orderBy"])) {
            $orderBy = 'ORDER BY '.$_POST["orderBy"].' DESC';
        } else {
            $orderBy = '';
        }
        if(isset($_POST["limit"])) {
            $limit = 'LIMIT '.$_POST["limit"];
        } else {
            $limit = '';
        }

        if(sessionCheck($conn)) {
            $result->status = true;
            $result->data = selectQuery($conn,$table,$conditions,$orderBy,$limit);
        } else {
            $result->status = false;
        }
        echo json_encode($result);
    }

    if($requestType == 'selectMultiQuery') {

        $tableA = $_POST["tableA"];
        $tableB = $_POST["tableB"];
        $tableAParem = $_POST["tableAParem"];
        $tableBParem = $_POST["tableBParem"];
        
        if(isset($_POST["conditions"])) {
            $conditions = $_POST["conditions"];
        } else {
            $conditions = 'WHERE 1 = 1';
        }
        if(isset($_POST["orderBy"])) {
            $orderBy = 'ORDER BY B.'.$_POST["orderBy"].' DESC';
        } else {
            $orderBy = '';
        }
        if(isset($_POST["limit"])) {
            $limit = 'LIMIT '.$_POST["limit"];
        } else {
            $limit = '';
        }



        if(sessionCheck($conn)) {
            $result->status = true;
            $result->data = selectMultiQuery($conn,$tableA,$tableB,$tableAParem,$tableBParem,$conditions,$orderBy,$limit);
        } else {
            $result->status = false;
        }
        echo json_encode($result);
    }


    if($requestType == 'selectLeftJoinQuery') {

        $tableA = $_POST["tableA"];
        $tableB = $_POST["tableB"];
        $onConditions = $_POST["onConditions"];
        $tableAColumns = $_POST["tableAColumns"];
        $columns = $_POST["columns"];
        
        if(isset($_POST["conditions"])) {
            $conditions = $_POST["conditions"];
        } else {
            $conditions = 'WHERE 1 = 1';
        }
        if(isset($_POST["orderBy"])) {
            $orderBy = 'ORDER BY B.'.$_POST["orderBy"].' DESC';
        } else {
            $orderBy = '';
        }
        if(isset($_POST["limit"])) {
            $limit = 'LIMIT '.$_POST["limit"];
        } else {
            $limit = '';
        }

        if(sessionCheck($conn)) {
            $result->status = true;
            $result->data = selectLeftJoinQuery($conn,$tableA,$tableB,$tableAColumns,$columns,$onConditions,$conditions,$orderBy,$limit);
        } else {
            $result->status = false;
        }
        echo json_encode($result);
    }

    if($requestType == 'selectDistinctQuery') {

        $table = $_POST["table"];
        if(isset($_POST["conditions"])) {
            $conditions = $_POST["conditions"];
        } else {
            $conditions = 'WHERE 1 = 1';
        }
        if(isset($_POST["limit"])) {
            $limit = 'LIMIT '.$_POST["limit"];
        } else {
            $limit = '';
        }
        if(isset($_POST["orderBy"])) {
            $orderBy = 'ORDER BY '.$_POST["orderBy"].' DESC';
        } else {
            $orderBy = '';
        }
        $distinct = $_POST["distinct"];

        if(sessionCheck($conn)) {
            $result->status = true;
            $result->data = selectDistinctQuery($conn,$table,$conditions,$distinct,$orderBy,$limit);
        } else {
            $result->status = false;
        }
        echo json_encode($result);
    }


    if($requestType == 'insertQuery') {
        $table = $_POST["table"];
        $parameters = $_POST["parameters"];
        if(isset($_POST["blob"])) {
            $blob = $_POST["blob"];
        } else {
            $blob = false;
        }
        // if(insertQuery($conn,$table,$parameters)) {
        //     $result->status = true;
        //     $result->notificationbg = $successColor;
        //     echo json_encode($result);
        // };
        // echo json_encode(insertQuery($conn,$table,$blob,$parameters));
        echo json_encode(insertQuery($conn,$table,$parameters));

    }

    if($requestType == 'updateQuery') {
        $table = $_POST["table"];
        $parameters = $_POST["parameters"];
        $conditions = $_POST["conditions"];
        if(updateQuery($conn,$table,$parameters,$conditions)) {
            $result->status = true;
            // $result->status = updateQuery($conn,$table,$parameters,$conditions);
            echo json_encode($result);
        };
    }

    if($requestType == 'deleteQuery') {
        $table = $_POST["table"];
        $conditions = $_POST["conditions"];
        if(deleteQuery($conn,$table,$conditions)) {
            $result->status = true;
            echo json_encode($result);
        };
    }

    if($requestType == 'logout') {
        logout();
    }