
var backendIncludes = '../customAssets/backend/backendIncludes.php';
var topicId = localStorage.getItem('adminTopicID');

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

$(() => {
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'topics', //String //Mandatory
            conditions: 'WHERE id = ' + topicId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".topicName").val(item.name);
                $(".topicAbout").val(item.about);
            });
        });

});

$(document).on("click", ".topicUpdateSubmitBtn", function () {
    $(this).attr("disabled", true);

    if ($(".topicName").val() == '') {
        notificationTrigger('Name is Mandatory ', failureColor);
        $(".topicUpdateSubmitBtn").attr("disabled", false);
    } else {

        $.post(backendIncludes,
            {
                requestType: 'updateQuery',
                table: 'topics',  //String //Mandatory
                parameters: {  //Object //Mandatory
                    name: $(".topicName").val(),
                    about: $(".topicAbout").val()
                },
                conditions: {  //Object //Mandatory
                    id: topicId
                }
            }, (result) => {
                console.log(result);
                result = JSON.parse(result);
                if (result.status) {
                    $(".topicUpdateSubmitBtn").attr("disabled", false);
                    notificationTrigger('Topic updated Successfully', successColor);
                } else { }
            });
    }
});