
var backendIncludes = '../customAssets/backend/backendIncludes.php';
var subjectId = localStorage.getItem('adminSubjectID');

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

$(() => {
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'subjects', //String //Mandatory
            conditions: 'WHERE id = ' + subjectId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".subjectName").val(item.name);
                $(".subjectAbout").val(item.about);
            });
        });

});

$(document).on("click", ".subjectUpdateSubmitBtn", function () {
    $(this).attr("disabled", true);

    if ($(".subjectName").val() == '') {
        notificationTrigger('Name is Mandatory ', failureColor);
        $(".subjectUpdateSubmitBtn").attr("disabled", false);
    } else {

        $.post(backendIncludes,
            {
                requestType: 'updateQuery',
                table: 'subjects',  //String //Mandatory
                parameters: {  //Object //Mandatory
                    name: $(".subjectName").val(),
                    about: $(".subjectAbout").val()
                },
                conditions: {  //Object //Mandatory
                    id: subjectId
                }
            }, (result) => {
                console.log(result);
                result = JSON.parse(result);
                if (result.status) {
                    $(".subjectUpdateSubmitBtn").attr("disabled", false);
                    notificationTrigger('Subject updated Successfully', successColor);
                } else { }
            });
    }
});