function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());
var loggedInId = localStorage.getItem('loggedInId');
// localStorage.subAdminId = "Smith";
// var subAdminId = localStorage.getItem('subAdminId');

$(function () {
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'admin', //String //Mandatory
            conditions: "WHERE status = 'Active' AND id != " + loggedInId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".adminSubAdminCards").append(`<div class="col-12 col-md-5 col-lg-3 d-flex cardBox cursor">
                                                    <a class="subAdminId" subAdmin-id="`+ item.id + `" redirect-to="subAdminDetails">
                                                        <div class="card flex-fill bg-white">
                                                            <img class="card-img-top"
                                                                src="./../customAssets/images/profiles/`+ item.profilePic + `"
                                                                onerror="this.onerror=null;this.src='../customAssets/images/profiles/defaultProfilePic.png';"
                                                                width="25" alt="Star Students">
                                                            <div class="card-header">
                                                                <h5 class="card-title mb-0">`+ item.fname + `</h5>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="cardBoxDetailsIndi">
                                                                    <i class="fa fa-user"></i>
                                                                    <span>`+ item.role + `</span>
                                                                </div>
                                                                <div class="cardBoxDetailsIndi">
                                                                    <i class="fa fa-envelope"></i>
                                                                    <span>`+ item.email + `</span>
                                                                </div>
                                                                <div class="cardBoxDetailsIndi">
                                                                    <i class="fa fa-tty"></i>
                                                                    <span>`+ item.phone + `</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>`);
            });

        });

});

$(document).on("click", ".subAdminId", function () {
    localStorage.subAdminId = $(this).attr("subAdmin-id");
    window.location.replace("../" + $(this).attr("redirect-to") + "/");
});