function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());
// localStorage.subAdminId = "Smith";
var subAdminId = localStorage.getItem('subAdminId');
// localStorage.removeItem("loggedInId");

$(function () {

    // Profile Data load -------------------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'admin', //String //Mandatory
            conditions: "WHERE id != " + subAdminId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".adminSubAdminProfilePic").html(`<img class=""
                                                        src="./../customAssets/images/profiles/`+ item.profilePic + `"
                                                        onerror="this.onerror=null;this.src='../customAssets/images/profiles/defaultProfilePic.png';"
                                                        width="25" alt="Star Students">`);
                $(".subAdminName").text(item.fname);
                $(".subAdminDate").text(dateFormatter(item.date));
                $(".subAdminPhone").text(item.phone);
                $(".subAdminEmail").text(item.email);
                $(".subAdminGender").text(item.gender);
                $(".subAdminAddress").text(item.address);
            });
        });

    // Restrictions load -------------------
    var accesses = ['studentAccess', 'examAccess', 'questionAccess', 'resultAccess'];
    var insertedAccesses = [];

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'subadminrestrictions', //String //Mandatory
            conditions: "WHERE aId = " + subAdminId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);

            result.data.forEach((item, i) => {
                if (accesses.includes(item.access)) {
                    insertedAccesses.push(item.access);
                    if (item.status == 'Enabled') {
                        $("." + item.access).html(`<span class="badge badge-gradient-success accessToggle cursor" access-id="` + item.access + `" access-status="` + item.status + `">Enabled</span>`);
                    } else {
                        $("." + item.access).html(`<span class="badge badge-gradient-dark accessToggle cursor" access-id="` + item.access + `" access-status="` + item.status + `">Disabled</span>`);
                    }
                } else { }
            });

            accesses.forEach((assesesItem) => {
                if (insertedAccesses.includes(assesesItem)) { } else {

                    $.post(backendIncludes,
                        {
                            requestType: 'insertQuery',
                            table: 'subadminrestrictions', //String //Mandatory
                            parameters: { // Object // Mandatory
                                access: assesesItem,
                                status: 'Disabled',
                                aId: subAdminId
                            }
                        }, (result) => {
                        });
                }
            });

        });
});

$(document).on("click", ".accessToggle", function () {
    var accessToggle = $(this).attr("access-id");
    var accessStatus = ($(this).attr("access-status") == 'Enabled') ? 'Disabled' : 'Enabled';

    $.post(backendIncludes,
        {
            requestType: 'updateQuery',
            table: 'subadminrestrictions',  //String //Mandatory
            parameters: {  //Object //Mandatory
                status: accessStatus,
            },
            conditions: {  //Object //Mandatory
                aId: subAdminId,
                access: accessToggle,
            }
        }, (result) => {
            result = JSON.parse(result);
            console.log(result);
            if (result.status) {
                if (accessStatus == 'Enabled') {
                    $("." + accessToggle).html(`<span class="badge badge-gradient-success accessToggle cursor"
                                                    access-id="`+ accessToggle + `"
                                                    access-status="Enabled">Enabled</span>`);
                } else {
                    $("." + accessToggle).html(`<span class="badge badge-gradient-dark accessToggle cursor"
                                                    access-id="`+ accessToggle + `"
                                                    access-status="Disabled">Disabled</span>`)
                }
            }
        });

});