
var backendIncludes = '../customAssets/backend/backendIncludes.php';

$(function () {

    var studentId = localStorage.getItem('adminStudentId');

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'students', //String //Mandatory
            conditions: 'WHERE id = ' + studentId
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $(".adminStudentDetailsProfilePic").html(`<img class="rounded-circle"
                                                                src="./../../student/customAssets/images/profiles/`+ item.profilePic + `"
                                                                onerror="this.onerror=null;this.src='../customAssets/images/profiles/defaultProfilePic.png';"
                                                                width="25" alt="Star Students">`);
                    $(".adminStudentDetailsName").text(item.fname + item.lname);
                    $(".adminStudentDetailsCourse").text(item.course);
                    $(".adminStudentDetailsPhone").text(item.phone);
                    $(".adminStudentDetailsEmail").text(item.email);
                    $(".adminStudentDetailsGender").text(item.gender);
                    $(".adminStudentDetailsDOB").text(item.dob);
                    $(".adminStudentDetailsAddress").text(item.address);
                    $(".adminStudentDetailsAbout").text(item.about);
                });
            }
        });

    // Exams Count ------------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'activeexams', //String //Mandatory
            conditions: "WHERE sId = " + studentId
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                $(".adminStudentDetailsExamsGiven").text(result.data.length);
            }
        }
    );

    // Avg Score Sum ------------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'results', //String //Mandatory
            conditions: "WHERE sId = " + studentId + " AND status = 'Cleared'"
        }, (result) => {
            result = JSON.parse(result);
            console.log(result)
            if (result.status) {
                result.data.forEach((item) => {
                    console.log(parseInt($(".adminStudentDetailsAvgScore").text()))
                    $(".adminStudentDetailsAvgScore").text((parseInt($(".adminStudentDetailsAvgScore").text()) + parseInt(item.percentage)) / result.data.length);
                });
            }
        }
    );


    // Recent Exams Glance  ------------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectMultiQuery',
            tableA: 'exams', //String //Mandatory
            tableB: 'results', //String //Mandatory
            tableAParem: 'id',
            tableBParem: 'eId',
            orderBy: 'id', // tableB columns only //String // Non Mandatory
            limit: 5 // Number // Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                var colorArray = ['bg-photoshop', 'bg-editor', 'bg-illustrator'];
                result.data.forEach((item, i) => {
                    $(".adminStudentDetailsRecentsExamsGlance").append(`<div class="skill-statistics">
                                                                            <div class="skills-head">
                                                                                <h5>`+ item.name + `</h5>
                                                                                <p>`+ item.percentage + `%</p>
                                                                            </div>
                                                                            <div class="progress mb-0">
                                                                                <div class="progress-bar `+ colorArray[i] + `" role="progressbar"
                                                                                    style="width: `+ item.percentage + `%" aria-valuenow="` + item.percentage + `" aria-valuemin="0"
                                                                                    aria-valuemax="100"></div>
                                                                            </div>
                                                                        </div>`);
                });
            }
        }
    );


});