var backendIncludes = '../customAssets/backend/backendIncludes.php';

function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

// var successColor = '#76a93a';
// var warningColor = '#c3973d';
// var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

var resultDetailsType = localStorage.getItem('resultDetailsType');
var statusBgColor = (resultDetailsType == 'complete') ? 'badge-gradient-danger' : 'badge-gradient-warning';
var percentageBgColor = (resultDetailsType == 'complete') ? 'bg-success' : 'bg-warning';

$(() => {
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'results', //String //Mandatory
            conditions: "WHERE status = '" + resultDetailsType + "'", //String //Non Mandatory
            orderBy: 'id', //String // Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {

                    $.post(backendIncludes,
                        {
                            requestType: 'selectQuery',
                            table: 'exams', //String //Mandatory
                            conditions: "WHERE id = '" + item.eId + "'", //String //Non Mandatory
                        }, (resultExam) => {
                            resultExam = JSON.parse(resultExam);
                            if (resultExam.status) {

                                $.post(backendIncludes,
                                    {
                                        requestType: 'selectQuery',
                                        table: 'students', //String //Mandatory
                                        conditions: "WHERE id = '" + item.sId + "'", //String //Non Mandatory
                                    }, (resultStudents) => {
                                        resultStudents = JSON.parse(resultStudents);
                                        if (resultStudents.status) {

                                            $(".resultsList").append(`<tr>
                                                                        <td>PRE${item.aEId}</td>
                                                                        <td>${resultExam.data[0].name}</td>
                                                                        <td>
                                                                            <h2 class="table-avatar">
                                                                                ${resultStudents.data[0].fname}
                                                                            </h2>
                                                                        </td>
                                                                        <td>${dateFormatter(item.date)}</td>
                                                                        <td><span class="badge ${percentageBgColor}">${resultDetailsType}</span></td>
                                                                        <td><span class="badge ${statusBgColor}">${item.percentage}%</span></td>
                                                                        <td class="text-end">
                                                                            <div class="actions trActions">
                                                                                <a href="#" class="btn btn-primary"><i
                                                                                        class="fas fa-download"></i></a>
                                                                            </div>
                                                                        </td>
                                                                    </tr>`);
                                        }
                                    });

                            }
                        });


                });


            }
        });
});