function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

$(() => {

    //Default Topics -------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'topics', //String //Mandatory
            conditions: "WHERE status = 'Active'", //String //Non Mandatory 
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $(".questionTopic").append(`<option>` + item.name + `</option>`);
                });
            }
        });

    //Default Subject -------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'subjects', //String //Mandatory
            conditions: "WHERE status = 'Active'", //String //Non Mandatory 
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $(".questionSubject").append(`<option>` + item.name + `</option>`);
                });
            }
        });
});


$(document).on("click", ".addQuestionBtn", function () {
    // console.log($(".questionType").val())

    for (let i = 0; i < ($(".options").length); i++) {
        if ($('input[name="questionTypeMCQCorrect"]').eq(i).is(":checked")) {
            var correctAnsw = 1;
        } else {
            var correctAnsw = 0;
        }
        console.log(correctAnsw)
    }

    $(this).attr("disabled", true);
    if ($(".questionTopic").val() == 'Choose Topic') {
        notificationTrigger('Please choose a Topic', warningColor);
        $(this).attr("disabled", false);
    } else if ($(".questionSubject").val() == 'Choose Subject') {
        notificationTrigger('Please choose a Subject', warningColor);
        $(this).attr("disabled", false);
    } else if ($(".question").val() == '') {
        notificationTrigger('Question Can not be empty', warningColor);
        $(this).attr("disabled", false);
    } else {

        if ($("#questionType_mcq").is(":checked")) {
            var parameters = {
                question: $(".question").val(),
                summary: $(".questionSummary").val(),
                type: 'mcqOptions',
                topic: $(".questionTopic").val(),
                subject: $(".questionSubject").val(),
                answerSummary: $(".answerSummary").val(),
                date: todayDate
            };
        } else if ($("#questionType_blank").is(":checked")) {
            var parameters = {
                question: $(".question").val(),
                summary: $(".questionSummary").val(),
                type: 'blankAnswer',
                topic: $(".questionTopic").val(),
                subject: $(".questionSubject").val(),
                answer: $(".answer").val(),
                answerSummary: $(".answerSummary").val(),
                date: todayDate
            };
        } else { }

        $.post(backendIncludes,
            {
                requestType: 'insertQuery',
                table: 'questions', //String //Mandatory
                parameters: parameters,
                // blob: {
                //      profilePic: 'image.src' //String //Optional
                // }
            }, (result) => {

                if ($("#questionType_mcq").is(":checked")) {
                    for (let i = 0; i < ($(".options").length); i++) {

                        $.post(backendIncludes,
                            {
                                requestType: 'insertQuery',
                                table: 'questionoptions', //String //Mandatory
                                parameters: {
                                    optionName: $(".options").eq(i).val(),
                                    qId: result,
                                    // status: $(".options").eq(i).attr("correct")
                                },
                                // blob: {
                                //      profilePic: 'image.src' //String //Optional
                                // }
                            }, (result) => {
                                console.log(result)
                            });
                    }
                }
                notificationTrigger('Question Added Successfully', successColor);
                $(this).attr("disabled", false);
            });
    }
});




$(document).on("change", ".questionType", function () {
    if ($(this).val() == 'mcqOptions') {
        $(".questionsAddBlankAnswerParent").css("display", "none");
        $(".questionsAddMCQOptionsParent, .questionsAddMCQOptionsAdd").css("display", "grid");
    } else if ($(this).val() == 'blankAnswer') {
        $(".questionsAddBlankAnswerParent").css("display", "block");
        $(".questionsAddMCQOptionsParent, .questionsAddMCQOptionsAdd").css("display", "none");
    } else { }
});

$(document).on("click", ".questionsAddMCQOptionsAddTextOption", function () {
    $(".questionsAddMCQOptionsParent").append(`<div class="form-group questionsAddMCQOptionsIndi">
                                                    <input class="form-check-input" type="radio" name="questionTypeMCQCorrect"
                                                        id="" value="1">
                                                    <label class="form-check-label" for="questionTypeMCQCorrect"><b>Option xx</b></label>
                                                    <div class="questionsAddMCQOptionsIndiContent">
                                                        <input type="text" class="form-control options">
                                                        <i class="fa fa-trash questionsAddMCQOptionsIndiRemoveIcon"></i>
                                                    </div>
                                                 </div>`);
});

$(document).on("click", ".questionsAddMCQOptionsAddImageOption", function () {
    $(".questionsAddMCQOptionsParent").append(`<div class="form-group questionsAddMCQOptionsIndi">
                                                    <input class="form-check-input" type="radio" name="questionTypeMCQCorrect"
                                                        id="" value="1">
                                                    <label class="form-check-label" for="questionTypeMCQCorrect"><b>Option xx</b></label>
                                                    <div class="questionsAddMCQOptionsIndiContent">
                                                        <input type="file" class="form-control options">
                                                        <i class="fa fa-trash questionsAddMCQOptionsIndiRemoveIcon"></i>
                                                    </div>
                                                 </div>`);
});

$(document).on("click", ".questionTypeMCQCorrect", function () {
    $(".options").attr("correct", false);
    $(this).closest('.questionsAddMCQOptionsIndi').find(".options").attr("correct", true);
});

$(document).on("click", ".questionsAddMCQOptionsIndiRemoveIcon", function () {
    $(this).parents('.questionsAddMCQOptionsIndi').first().remove();
});